/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWInvokeAdvancedPanel;
import filenet.vw.toolkit.runtime.property.VWInvokeCorrelationSetPanel;
import filenet.vw.toolkit.runtime.property.VWInvokeFaultsPanel;
import filenet.vw.toolkit.runtime.property.VWInvokeGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWSystemStepGeneralPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWInvokeParamPanel
extends JPanel {
    protected static final int MODE_BASIC = 0;
    protected static final int MODE_ADVANCED = 1;
    private static final int TAB_COUNT = 4;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_ADVANCED = 1;
    private static final int TAB_FAULTS = 2;
    private static final int TAB_CORRELATION_SET = 3;
    private VWSystemStepGeneralPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private VWInvokeGeneralPanel m_generalPanel = null;
    private VWInvokeAdvancedPanel m_advancedPanel = null;
    private VWInvokeFaultsPanel m_faultsPanel = null;
    private VWInvokeCorrelationSetPanel m_correlationSetPanel = null;
    protected JTabbedPane m_invokeTabbedPane = null;

    public VWInvokeParamPanel(VWSystemStepGeneralPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.init();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (instructionDef instanceof VWInvokeInstruction) {
            VWInvokeInstruction invoke = (VWInvokeInstruction)instructionDef;
            this.m_instructionDef = invoke;
            this.m_generalPanel.setInstructionDefinition(invoke);
            this.m_advancedPanel.setInstructionDefinition(invoke);
            this.m_faultsPanel.setInstructionDefinition(invoke);
            this.m_correlationSetPanel.setInstructionDefinition(invoke);
            if (this.getInvokeMessageType() == 1) {
                if (this.m_invokeTabbedPane.getTabCount() < 4) {
                    this.m_invokeTabbedPane.addTab(VWResource.s_correlationSet, this.m_correlationSetPanel);
                }
            } else if (this.m_invokeTabbedPane.getTabCount() == 4) {
                this.m_invokeTabbedPane.removeTabAt(3);
            }
        }
    }

    private void init() {
        this.setupLayout();
        this.m_invokeTabbedPane.setTabPlacement(1);
        this.m_generalPanel = new VWInvokeGeneralPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_advancedPanel = new VWInvokeAdvancedPanel(this, this.m_instructionDef);
        this.m_faultsPanel = new VWInvokeFaultsPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_correlationSetPanel = new VWInvokeCorrelationSetPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_invokeTabbedPane.addTab(VWResource.s_general, this.m_generalPanel);
        this.m_invokeTabbedPane.addTab(VWResource.s_advanced, this.m_advancedPanel);
        this.m_invokeTabbedPane.addTab(VWResource.s_faults, this.m_faultsPanel);
        this.m_invokeTabbedPane.addTab(VWResource.s_correlationSet, this.m_correlationSetPanel);
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.fill = 1;
        gbCons.anchor = 10;
        this.m_invokeTabbedPane = new JTabbedPane();
        this.add((Component)this.m_invokeTabbedPane, gbCons);
    }

    protected int getInvokeMessageType() {
        try {
            if (this.m_instructionDef != null) {
                if (((VWInvokeInstruction)this.m_instructionDef).getOutGoingParameterDefinitions() == null && ((VWInvokeInstruction)this.m_instructionDef).getInComingParameterDefinitions() == null) {
                    return 1;
                }
                return 0;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    protected Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        return this.m_parent.getTypeFromParam(paramDef);
    }

    protected void setupTableCellRenderer(VWTable table, AbstractTableModel tableModel) {
        this.m_parent.setupTableCellRenderer(table, tableModel);
    }

    protected void setTextField(JTextField field, String text) {
        this.m_parent.setTextField(field, text);
    }

    public void removeReferences() {
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeReferences();
        }
        if (this.m_advancedPanel != null) {
            this.m_advancedPanel.removeReferences();
        }
        if (this.m_faultsPanel != null) {
            this.m_faultsPanel.removeReferences();
        }
        if (this.m_correlationSetPanel != null) {
            this.m_correlationSetPanel.removeReferences();
        }
        this.m_invokeTabbedPane = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

